<?php
/**
 * JIHUDUMIE HAPA - WiFi Self Service Page
 * Save as: /xampp/htdocs/mikhmon/jihudumie_hapa.php
 * 
 * This page allows customers to self-repair their WiFi vouchers without admin login
 */

// Hide all PHP errors from display
error_reporting(0);
ini_set('display_errors', 0);

// Include MikHmon's API connection - adjust path if needed
// Uncomment and modify the path below to match your MikHmon installation
// require_once __DIR__ . '/inc/config.php';
// require_once __DIR__ . '/inc/func.php';

// For now, we'll assume $API is available globally like in other MikHmon pages
// If you get "$API not found" error, you'll need to include the proper MikHmon bootstrap files

// Handle AJAX requests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    $action = $_POST['action'];
    
    if ($action === 'search_voucher') {
        $voucher = trim($_POST['voucher'] ?? '');
        
        if (strlen($voucher) !== 7 || !ctype_digit($voucher)) {
            echo json_encode(['success' => false, 'message' => 'Voucher lazima iwe na nambari 7 tu']);
            exit;
        }
        
        // Check if $API exists
        if (!isset($API)) {
            echo json_encode(['success' => false, 'message' => 'Kuna tatizo la sistem. Jaribu baadaye.']);
            exit;
        }
        
        try {
            // Search for user by name first
            $user = $API->comm("/ip/hotspot/user/print", array("?name" => $voucher));
            
            if (empty($user)) {
                // Try searching by comment
                $user = $API->comm("/ip/hotspot/user/print", array("?comment" => $voucher));
            }
            
            if (empty($user)) {
                // Search in comments that contain the voucher number
                $all_users = $API->comm("/ip/hotspot/user/print");
                foreach ($all_users as $u) {
                    if (strpos($u['comment'], $voucher) !== false || strpos($u['name'], $voucher) !== false) {
                        $user = array($u);
                        break;
                    }
                }
            }
            
            if (!empty($user)) {
                $found_user = $user[0];
                echo json_encode([
                    'success' => true,
                    'user' => array(
                        'id' => $found_user['.id'],
                        'name' => $found_user['name'],
                        'password' => $found_user['password'],
                        'profile' => $found_user['profile'],
                        'uptime' => $found_user['uptime'] ?? '0',
                        'limit_uptime' => $found_user['limit-uptime'] ?? '',
                        'limit_bytes' => $found_user['limit-bytes-total'] ?? '',
                        'comment' => $found_user['comment'] ?? '',
                        'server' => $found_user['server'] ?? 'all'
                    )
                ]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Voucher haijapatikana. Hakikisha umeweka nambari sahihi.']);
            }
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Kuna tatizo la sistem. Jaribu baadaye.']);
        }
        exit;
    }
    
    if ($action === 'repair_voucher') {
        if (!isset($API)) {
            echo json_encode(['success' => false, 'message' => 'Kuna tatizo la sistem.']);
            exit;
        }
        
        $user_data = json_decode($_POST['user_data'], true);
        
        try {
            // Step 1: Remove old user
            $API->comm("/ip/hotspot/user/remove", array(".id" => $user_data['id']));
            
            // Step 2: Remove any cookies for this user
            $cookies = $API->comm("/ip/hotspot/cookie/print", array("?user" => $user_data['name']));
            foreach ($cookies as $cookie) {
                $API->comm("/ip/hotspot/cookie/remove", array(".id" => $cookie['.id']));
            }
            
            // Step 3: Re-add the user with same details
            $API->comm("/ip/hotspot/user/add", array(
                "server" => $user_data['server'],
                "name" => $user_data['name'],
                "password" => $user_data['password'],
                "profile" => $user_data['profile'],
                "limit-uptime" => $user_data['limit_uptime'],
                "limit-bytes-total" => $user_data['limit_bytes'],
                "comment" => $user_data['comment']
            ));
            
            echo json_encode([
                'success' => true, 
                'voucher' => $user_data['name'],
                'password' => $user_data['password']
            ]);
            
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Kuna tatizo la sistem wakati wa kurekebisha.']);
        }
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="sw">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jihudumie Hapa - WiFi Self Service</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #ff6b6b, #feca57);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .content {
            padding: 30px 20px;
        }
        
        .explanation {
            background: #f8f9fa;
            border-left: 5px solid #17a2b8;
            padding: 20px;
            margin-bottom: 30px;
            border-radius: 5px;
        }
        
        .explanation h2 {
            color: #495057;
            margin-bottom: 15px;
            font-size: 1.2em;
        }
        
        .explanation p {
            color: #6c757d;
            line-height: 1.6;
        }
        
        .search-section {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .search-label {
            font-size: 1.3em;
            color: #495057;
            margin-bottom: 15px;
            display: block;
            font-weight: 600;
        }
        
        .search-input {
            width: 100%;
            max-width: 300px;
            padding: 15px 20px;
            font-size: 1.5em;
            text-align: center;
            border: 3px solid #dee2e6;
            border-radius: 25px;
            outline: none;
            transition: all 0.3s ease;
            letter-spacing: 2px;
        }
        
        .search-input:focus {
            border-color: #007bff;
            box-shadow: 0 0 0 3px rgba(0,123,255,0.25);
        }
        
        .loading {
            display: none;
            text-align: center;
            padding: 30px;
        }
        
        .spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #007bff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .loading-text {
            font-size: 1.2em;
            color: #495057;
            font-weight: 600;
        }
        
        .result {
            display: none;
            text-align: center;
        }
        
        .user-info {
            background: #e3f2fd;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .user-info h3 {
            color: #1976d2;
            margin-bottom: 15px;
        }
        
        .user-details {
            text-align: left;
            display: inline-block;
        }
        
        .user-details p {
            margin: 8px 0;
            color: #424242;
        }
        
        .user-details strong {
            color: #1976d2;
        }
        
        .repair-btn {
            background: linear-gradient(135deg, #ff6b6b, #feca57);
            color: white;
            border: none;
            padding: 15px 30px;
            font-size: 1.2em;
            border-radius: 25px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 600;
            text-transform: uppercase;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .repair-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px rgba(0,0,0,0.3);
        }
        
        .success {
            display: none;
            text-align: center;
            padding: 30px;
        }
        
        .success-icon {
            font-size: 4em;
            color: #28a745;
            margin-bottom: 20px;
        }
        
        .success h2 {
            color: #28a745;
            margin-bottom: 20px;
        }
        
        .voucher-display {
            background: #d4edda;
            border: 2px solid #28a745;
            border-radius: 10px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .voucher-code {
            font-size: 2em;
            font-weight: bold;
            color: #155724;
            margin: 10px 0;
            letter-spacing: 2px;
        }
        
        .copy-redirect-btn {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            border: none;
            padding: 15px 30px;
            font-size: 1.1em;
            border-radius: 25px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 600;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            margin: 10px;
        }
        
        .copy-redirect-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px rgba(0,0,0,0.3);
        }
        
        .error {
            color: #dc3545;
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .container {
                margin: 10px;
            }
            
            .header h1 {
                font-size: 2em;
            }
            
            .content {
                padding: 20px 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔧 JIHUDUMIE HAPA 🔧</h1>
        </div>
        
        <div class="content">
            <div class="explanation">
                <h2>📶 Kama Voucher Yako Inasumbua?</h2>
                <p>Kama voucher yako haikubali, imekutoa kabla ya muda, au umehama jina la WiFi ulilokua unaitumia kwenda nyingine, weka voucher yako hapo chini ili tuirekebishe.</p>
            </div>
            
            <div id="searchSection" class="search-section">
                <label class="search-label" for="voucherInput">
                    📱 Weka Voucher Yako Hapa:
                </label>
                <input 
                    type="text" 
                    id="voucherInput" 
                    class="search-input" 
                    placeholder="1234567"
                    maxlength="7"
                    pattern="\d{7}"
                >
                <div id="errorMsg" class="error" style="display:none;"></div>
            </div>
            
            <div id="loadingSection" class="loading">
                <div class="spinner"></div>
                <div class="loading-text">Tunalishughulika tafadhali subiri...</div>
            </div>
            
            <div id="resultSection" class="result">
                <div class="user-info">
                    <h3>📋 Voucher Imepatikana:</h3>
                    <div id="userDetails" class="user-details"></div>
                </div>
                <button id="repairBtn" class="repair-btn">
                    🔧 Bonyeza Hapa Kurekebisha
                </button>
            </div>
            
            <div id="successSection" class="success">
                <div class="success-icon">✅</div>
                <h2>Hongera!</h2>
                <div class="voucher-display">
                    <div>Voucher Yako:</div>
                    <div id="finalVoucher" class="voucher-code"></div>
                    <div>Password:</div>
                    <div id="finalPassword" class="voucher-code"></div>
                </div>
                <p><strong>Vocha yako ipo Tayari! Asante kwa kutumia. Jiache WiFi.</strong></p>
                <button id="copyRedirectBtn" class="copy-redirect-btn">
                    📋 Bonyeza Hapa Kuicopy na Kwenda Kuiweka ili Utumie
                </button>
            </div>
        </div>
    </div>

    <script>
        let foundUser = null;
        
        // Only search when user types exactly 7 digits
        document.getElementById('voucherInput').addEventListener('input', function(e) {
            const value = e.target.value;
            const errorMsg = document.getElementById('errorMsg');
            
            // Clear previous error
            errorMsg.style.display = 'none';
            
            // Hide result section when typing
            document.getElementById('resultSection').style.display = 'none';
            
            // Only allow digits
            e.target.value = value.replace(/\D/g, '');
            
            // Search when exactly 7 digits are entered
            if (e.target.value.length === 7) {
                searchVoucher(e.target.value);
            }
        });
        
        function searchVoucher(voucher) {
            document.getElementById('loadingSection').style.display = 'block';
            document.getElementById('searchSection').style.display = 'none';
            
            fetch(window.location.href, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `action=search_voucher&voucher=${voucher}`
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById('loadingSection').style.display = 'none';
                document.getElementById('searchSection').style.display = 'block';
                
                if (data.success) {
                    foundUser = data.user;
                    showResult(data.user);
                } else {
                    showError(data.message);
                }
            })
            .catch(error => {
                document.getElementById('loadingSection').style.display = 'none';
                document.getElementById('searchSection').style.display = 'block';
                showError('Kuna tatizo la mtandao. Jaribu tena.');
            });
        }
        
        function showResult(user) {
            const userDetails = document.getElementById('userDetails');
            userDetails.innerHTML = `
                <p><strong>Jina:</strong> ${user.name}</p>
                <p><strong>Password:</strong> ${user.password}</p>
                <p><strong>Profile:</strong> ${user.profile}</p>
                <p><strong>Uptime:</strong> ${user.uptime || 'Hapana'}</p>
            `;
            
            document.getElementById('resultSection').style.display = 'block';
        }
        
        function showError(message) {
            const errorMsg = document.getElementById('errorMsg');
            errorMsg.textContent = message;
            errorMsg.style.display = 'block';
        }
        
        // Repair button click handler
        document.getElementById('repairBtn').addEventListener('click', function() {
            if (!foundUser) return;
            
            document.getElementById('resultSection').style.display = 'none';
            document.getElementById('loadingSection').style.display = 'block';
            
            fetch(window.location.href, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `action=repair_voucher&user_data=${encodeURIComponent(JSON.stringify(foundUser))}`
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById('loadingSection').style.display = 'none';
                
                if (data.success) {
                    document.getElementById('finalVoucher').textContent = data.voucher;
                    document.getElementById('finalPassword').textContent = data.password;
                    document.getElementById('successSection').style.display = 'block';
                    
                    // Store voucher info in localStorage for the copy function
                    localStorage.setItem('lastVoucher', data.voucher);
                    localStorage.setItem('lastPassword', data.password);
                } else {
                    document.getElementById('searchSection').style.display = 'block';
                    showError(data.message);
                }
            })
            .catch(error => {
                document.getElementById('loadingSection').style.display = 'none';
                document.getElementById('searchSection').style.display = 'block';
                showError('Kuna tatizo la mtandao wakati wa kurekebisha.');
            });
        });
        
        // Copy and redirect button
        document.getElementById('copyRedirectBtn').addEventListener('click', function() {
            const voucher = localStorage.getItem('lastVoucher');
            const password = localStorage.getItem('lastPassword');
            
            if (voucher && password) {
                const textToCopy = `Username: ${voucher}\nPassword: ${password}`;
                
                // Try to copy to clipboard
                if (navigator.clipboard) {
                    navigator.clipboard.writeText(textToCopy).then(() => {
                        alert('Voucher imecopy! Sasa utapelekwa kwenye router.');
                        window.open('http://10.0.0.1', '_blank');
                    }).catch(() => {
                        // Fallback: show the voucher info
                        alert(`Username: ${voucher}\nPassword: ${password}\n\nCopy hii info na uweke kwenye router.`);
                        window.open('http://10.0.0.1', '_blank');
                    });
                } else {
                    // Fallback for older browsers
                    alert(`Username: ${voucher}\nPassword: ${password}\n\nCopy hii info na uweke kwenye router.`);
                    window.open('http://10.0.0.1', '_blank');
                }
            }
        });
    </script>
</body>
</html>