<?php
session_start();
// Enable error reporting for debugging, but suppress notices
error_reporting(E_ALL & ~E_NOTICE);
ob_start("ob_gzhandler");

$session = $_GET['session'] ?? 'session1';

include('./include/config.php');
include('./include/readcfg.php');
include_once('./lib/routeros_api.class.php');
include_once('./lib/formatbytesbites.php');

$connection_status = 'Not Connected';
$connection_color = 'red';
$API = null;

if (class_exists('RouterosAPI') && isset($iphost) && isset($userhost) && isset($passwdhost) && function_exists('decrypt')) {
    ini_set("max_execution_time", 20); // Increased to 20 seconds for slower responses
    $API = new RouterosAPI();
    $API->debug = false;
    try {
        if (!$API->connect($iphost, $userhost, decrypt($passwdhost))) {
            error_log("API connection failed: IP=$iphost, User=$userhost");
            $connection_status = 'Not Connected';
            $connection_color = 'red';
        } else {
            $connection_status = 'Connected';
            $connection_color = 'green';
        }
    } catch (Exception $e) {
        error_log("API connection error: " . $e->getMessage());
        $connection_status = 'Connection Error';
        $connection_color = 'red';
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $action = $_POST['action'];
    
    if ($action === 'search_voucher') {
        $voucher = trim($_POST['voucher'] ?? '');
        if (strlen($voucher) < 7) {
            echo json_encode(['success' => false, 'message' => 'Voucher lazima iwe na angalau herufi 7']);
            exit;
        }
        if (!isset($API) || $connection_status !== 'Connected') {
            echo json_encode(['success' => false, 'message' => 'Router haipatikani. Tafadhali angalia muunganisho.']);
            exit;
        }
        
        try {
            $getuser = $API->comm("/ip/hotspot/user/print", array("?name" => $voucher));
            if (empty($getuser)) {
                $getuser = $API->comm("/ip/hotspot/user/print", array("?comment" => $voucher));
            }
            if (empty($getuser)) {
                $all_users = $API->comm("/ip/hotspot/user/print");
                foreach ($all_users as $user) {
                    if (stripos($user['name'] ?? '', $voucher) !== false || stripos($user['comment'] ?? '', $voucher) !== false) {
                        $getuser = array($user);
                        break;
                    }
                }
            }
            
            if (!empty($getuser)) {
                $user = $getuser[0];
                echo json_encode(['success' => true, 'user' => array(
                    'id' => $user['.id'], 
                    'name' => $user['name'], 
                    'password' => $user['password'],
                    'profile' => $user['profile'], 
                    'server' => $user['server'] ?? 'all',
                    'uptime' => $user['uptime'] ?? '0', 
                    'limit_uptime' => $user['limit-uptime'] ?? '',
                    'limit_bytes' => $user['limit-bytes-total'] ?? '', 
                    'comment' => $user['comment'] ?? ''
                )]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Voucher "' . htmlspecialchars($voucher) . '" haijapatikana']);
            }
        } catch (Exception $e) {
            error_log("Search voucher error: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Kuna tatizo: ' . htmlspecialchars($e->getMessage())]);
        }
        exit;
    }
    
    if ($action === 'repair_step') {
        if (!isset($API) || $connection_status !== 'Connected') {
            echo json_encode(['success' => false, 'message' => 'Router haipatikani. Tafadhali angalia muunganisho.']);
            exit;
        }
        
        $step = $_POST['step'];
        $user_data = json_decode($_POST['user_data'], true);
        
        // Validate user_data
        if (!isset($user_data['name']) || !isset($user_data['profile'])) {
            echo json_encode(['success' => false, 'message' => 'Data ya voucher haipo']);
            exit;
        }
        
        try {
            // Verify profile exists
            $profiles = $API->comm("/ip/hotspot/user/profile/print");
            $profile_exists = false;
            foreach ($profiles as $p) {
                if ($p['name'] === $user_data['profile']) {
                    $profile_exists = true;
                    break;
                }
            }
            if (!$profile_exists) {
                echo json_encode(['success' => false, 'message' => 'Profile "' . htmlspecialchars($user_data['profile']) . '" haipo kwenye router']);
                exit;
            }
            
            if ($step === 'remove_user') {
                $check_before = $API->comm("/ip/hotspot/user/print", array("?name" => $user_data['name']));
                if (!empty($check_before)) {
                    $API->comm("/ip/hotspot/user/remove", array(".id" => $user_data['id']));
                    $removed = false;
                    for ($i = 0; $i < 5; $i++) {
                        usleep(1500000); // 1.5 seconds for reliability
                        $check_after = $API->comm("/ip/hotspot/user/print", array("?name" => $user_data['name']));
                        if (empty($check_after)) {
                            $removed = true;
                            break;
                        }
                    }
                    echo json_encode($removed ? ['success' => true, 'step_completed' => 'remove_user'] : ['success' => false, 'message' => 'Voucher bado ipo baada ya majaribio']);
                } else {
                    echo json_encode(['success' => true, 'step_completed' => 'remove_user']);
                }
            } elseif ($step === 'remove_cookies') {
                $getcookies = $API->comm("/ip/hotspot/cookie/print", array("?user" => $user_data['name']));
                if ($getcookies && is_array($getcookies) && count($getcookies) > 0) {
                    foreach ($getcookies as $cookie) {
                        if (isset($cookie['.id'])) {
                            $API->comm("/ip/hotspot/cookie/remove", array(".id" => $cookie['.id']));
                        }
                    }
                    $cookies_removed = false;
                    for ($i = 0; $i < 5; $i++) {
                        usleep(1500000); // 1.5 seconds
                        $check_cookies = $API->comm("/ip/hotspot/cookie/print", array("?user" => $user_data['name']));
                        if (empty($check_cookies)) {
                            $cookies_removed = true;
                            break;
                        }
                    }
                    echo json_encode($cookies_removed ? ['success' => true, 'step_completed' => 'remove_cookies'] : ['success' => false, 'message' => 'Cookies bado zipo baada ya majaribio']);
                } else {
                    echo json_encode(['success' => true, 'step_completed' => 'remove_cookies']);
                }
            } elseif ($step === 'add_user') {
                // Pre-check to avoid unnecessary addition
                $check_exists = $API->comm("/ip/hotspot/user/print", array("?name" => $user_data['name']));
                if (!empty($check_exists)) {
                    // Verify if existing user matches expected profile
                    $existing_user = $check_exists[0];
                    if ($existing_user['name'] === $user_data['name'] && $existing_user['profile'] === $user_data['profile']) {
                        error_log("User already exists with correct profile: " . $user_data['name']);
                        echo json_encode([
                            'success' => true, 
                            'step_completed' => 'add_user', 
                            'voucher' => $user_data['name'], 
                            'password' => $user_data['password'],
                            'debug' => 'User already exists with correct profile'
                        ]);
                        exit;
                    } else {
                        $API->comm("/ip/hotspot/user/remove", array(".id" => $existing_user['.id']));
                        usleep(1500000); // 1.5 seconds
                    }
                }
                
                $timelimit = ($user_data['limit_uptime'] == '' || $user_data['limit_uptime'] == '0') ? '0' : $user_data['limit_uptime'];
                $datalimit = ($user_data['limit_bytes'] == '' || $user_data['limit_bytes'] == '0') ? '0' : $user_data['limit_bytes'];
                
                $add_params = array(
                    "server" => $user_data['server'], 
                    "name" => $user_data['name'], 
                    "password" => $user_data['password'], 
                    "profile" => $user_data['profile'], 
                    "disabled" => "no"
                );
                if ($timelimit != '0') $add_params["limit-uptime"] = $timelimit;
                if ($datalimit != '0') $add_params["limit-bytes-total"] = $datalimit;
                if (!empty($user_data['comment'])) $add_params["comment"] = $user_data['comment'];
                
                // Add user
                $API->comm("/ip/hotspot/user/add", $add_params);
                
                $user_added = false;
                $max_verify_attempts = 5; // Reduced attempts, rely on pre-check
                for ($i = 0; $i < $max_verify_attempts; $i++) {
                    usleep(2000000); // Increased to 2 seconds for router sync
                    $verify_user = $API->comm("/ip/hotspot/user/print", array("?name" => $user_data['name']));
                    if ($verify_user && count($verify_user) > 0) {
                        $added_user = $verify_user[0];
                        if ($added_user['name'] === $user_data['name']) {
                            $user_added = true;
                            error_log("User added successfully: " . $user_data['name']);
                            break;
                        }
                    }
                    error_log("Verification attempt " . ($i+1) . " for user: " . $user_data['name'] . " - not found yet");
                }
                
                // Final check with no delay
                if (!$user_added) {
                    $final_verify = $API->comm("/ip/hotspot/user/print", array("?name" => $user_data['name']));
                    if ($final_verify && count($final_verify) > 0 && $final_verify[0]['name'] === $user_data['name']) {
                        $user_added = true;
                        error_log("User found on final check: " . $user_data['name']);
                    } else {
                        error_log("User addition failed completely: " . $user_data['name']);
                    }
                }
                
                $response = $user_added ? [
                    'success' => true, 
                    'step_completed' => 'add_user', 
                    'voucher' => $user_data['name'], 
                    'password' => $user_data['password'],
                    'debug' => 'User added and verified'
                ] : ['success' => false, 'message' => 'Voucher haijaongezwa baada ya majaribio'];
                echo json_encode($response);
            }
        } catch (Exception $e) {
            error_log("Repair step ($step) error: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Tatizo la mtandao: ' . htmlspecialchars($e->getMessage())]);
        }
        exit;
    }
    
    if ($action === 'create_temp_voucher') {
        if (!isset($API) || $connection_status !== 'Connected') {
            echo json_encode(['success' => false, 'message' => 'Router haipatikani. Tafadhali angalia muunganisho.']);
            exit;
        }
        
        $data = json_decode($_POST['data'], true);
        $phone = $data['phone'];
        $original = $data['original_voucher'];
        
        // Validate phone number
        if (!preg_match('/^[0-9]{10,12}$/', $phone)) {
            echo json_encode(['success' => false, 'message' => 'Nambari ya simu si sahihi']);
            exit;
        }
        
        try {
            // Verify profile exists
            $profiles = $API->comm("/ip/hotspot/user/profile/print");
            $profile = 'masaa3'; // Default profile
            $profile_exists = false;
            foreach ($profiles as $p) {
                if ($p['name'] === $profile) {
                    $profile_exists = true;
                    break;
                }
            }
            if (!$profile_exists) {
                // Fallback to first available profile
                if (!empty($profiles)) {
                    $profile = $profiles[0]['name'];
                } else {
                    echo json_encode(['success' => false, 'message' => 'Hakuna profile zinazopatikana kwenye router']);
                    exit;
                }
            }
            
            // Generate random voucher without prefix
            $temp = substr(str_shuffle(str_repeat('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', 5)), 0, 8); // 8-character random string
            $max_attempts = 3;
            $user_added = false;
            
            for ($i = 0; $i < $max_attempts; $i++) {
                try {
                    $API->comm("/ip/hotspot/user/add", array(
                        "server" => "all", 
                        "name" => $temp, 
                        "password" => $temp, 
                        "profile" => $profile, 
                        "disabled" => "no", 
                        "limit-uptime" => "3h", 
                        "comment" => "TEMP-" . $phone . "-FOR-" . $original
                    ));
                    usleep(2000000); // Increased to 2 seconds
                    $verify = $API->comm("/ip/hotspot/user/print", array("?name" => $temp));
                    
                    if ($verify && count($verify) > 0 && $verify[0]['name'] === $temp) {
                        $user_added = true;
                        break;
                    }
                } catch (Exception $e) {
                    error_log("Temp voucher attempt $i failed: " . $e->getMessage());
                }
                usleep(2000000); // Wait before retry
            }
            
            if ($user_added) {
                $log = date('Y-m-d H:i:s') . " | $temp | $phone | $original\n";
                @file_put_contents(__DIR__ . '/logs/temp_vouchers.log', $log, FILE_APPEND);
                echo json_encode(['success' => true, 'voucher' => $temp, 'debug' => 'Temp voucher created successfully']);
            } else {
                error_log("Failed to create temporary voucher: $temp after $max_attempts attempts");
                echo json_encode(['success' => false, 'message' => 'Imeshindikana kuunda voucher ya muda']);
            }
        } catch (Exception $e) {
            error_log("Temp voucher creation error: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Tatizo la mtandao: ' . htmlspecialchars($e->getMessage())]);
        }
        exit;
    }
    
    if ($action === 'log_failure') {
        $step = $_POST['step'];
        $user_data = json_decode($_POST['user_data'], true);
        $retry = $_POST['retry_count'];
        $log = date('Y-m-d H:i:s') . " | $step | " . ($user_data['name'] ?? 'unknown') . " | $retry\n";
        @file_put_contents(__DIR__ . '/logs/failures.log', $log, FILE_APPEND);
        echo json_encode(['success' => true]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="sw">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jihudumie Hapa</title>
<style>
*{margin:0;padding:0;box-sizing:border-box}
body{font-family:'Segoe UI',sans-serif;background:linear-gradient(135deg,#667eea,#764ba2);min-height:100vh;padding:20px}
.container{max-width:600px;margin:0 auto;background:white;border-radius:15px;box-shadow:0 10px 30px rgba(0,0,0,0.3);overflow:hidden}
.header{background:linear-gradient(135deg,#ff6b6b,#feca57);color:white;padding:30px 20px;text-align:center}
.header h1{font-size:2.5em;margin-bottom:10px}
.status{display:flex;align-items:center;justify-content:center;margin-top:10px}
.dot{width:12px;height:12px;border-radius:50%;margin-right:8px}
.dot.green{background:#28a745;box-shadow:0 0 5px rgba(40,167,69,0.5)}
.dot.red{background:#dc3545;box-shadow:0 0 5px rgba(220,53,69,0.5)}
.content{padding:30px 20px}
.explanation{background:#f8f9fa;border-left:5px solid #17a2b8;padding:20px;margin-bottom:30px;border-radius:5px}
.search-section{text-align:center;margin-bottom:30px}
.search-label{font-size:1.3em;margin-bottom:15px;display:block;font-weight:600;color:#495057}
.search-group{display:flex;gap:10px;justify-content:center;flex-wrap:wrap}
.search-input{width:100%;max-width:300px;padding:15px 20px;font-size:1.3em;text-align:center;border:3px solid #dee2e6;border-radius:25px;outline:none}
.search-input:focus{border-color:#007bff;box-shadow:0 0 0 3px rgba(0,123,255,0.25)}
.btn{background:linear-gradient(135deg,#007bff,#0056b3);color:white;border:none;padding:15px 30px;font-size:1.1em;border-radius:25px;cursor:pointer;font-weight:600}
.btn:hover{transform:translateY(-2px)}
.btn:disabled{opacity:0.6;cursor:not-allowed}
.progress-section{display:none;text-align:center;padding:30px}
.progress-step{background:#f8f9fa;padding:15px;margin:10px 0;border-radius:10px;display:flex;align-items:center;justify-content:space-between}
.progress-step.active{background:#fff3cd;border-left:5px solid #ffc107}
.progress-step.completed{background:#d4edda;border-left:5px solid #28a745}
.progress-step.failed{background:#f8d7da;border-left:5px solid #dc3545}
.spinner{width:30px;height:30px;border:4px solid #f3f3f3;border-top:4px solid #007bff;border-radius:50%;animation:spin 1s linear infinite}
@keyframes spin{100%{transform:rotate(360deg)}}
.result{display:none;text-align:center}
.user-info{background:#e3f2fd;padding:20px;border-radius:10px;margin-bottom:20px}
.user-details{text-align:left;display:inline-block}
.error{color:#dc3545;background:#f8d7da;border:1px solid #f5c6cb;border-radius:5px;padding:15px;margin:15px 0}
.success{display:none;text-align:center;padding:30px}
.voucher-display{background:#d4edda;border:2px solid #28a745;border-radius:10px;padding:20px;margin:20px 0}
.voucher-code{font-size:2em;font-weight:bold;color:#155724;margin:10px 0}
</style>
</head>
<body>
<div class="container">
<div class="header">
<h1>🔧 JIHUDUMIE HAPA 🔧</h1>
<div class="status"><span class="dot <?=$connection_color?>"></span><span>Router: <?=$connection_status?></span></div>
</div>
<div class="content">
<div class="explanation">
<h2>📶 Kama Voucher Yako Inasumbua?</h2>
<p>Kama voucher yako haikubali, imekutoa kabla ya muda, au umehama WiFi, weka voucher yako hapo chini tuirekebishe.</p>
</div>
<div id="searchSection" class="search-section">
<label class="search-label">📱 Weka Voucher Yako Hapa:</label>
<div class="search-group">
<input type="text" id="voucherInput" class="search-input" placeholder="Andika voucher yako">
<button id="searchBtn" class="btn">🔍 Tafuta</button>
</div>
<div id="errorMsg" class="error" style="display:none"></div>
</div>
<div id="progressSection" class="progress-section">
<h3>Inaendelea...</h3>
<div>
<div class="progress-step" id="step1"><div><span>1️⃣</span> <strong>Kufuta voucher ya zamani</strong></div><div id="step1-status"></div></div>
<div class="progress-step" id="step2"><div><span>2️⃣</span> <strong>Kufuta cookies</strong></div><div id="step2-status"></div></div>
<div class="progress-step" id="step3"><div><span>3️⃣</span> <strong>Kuongeza voucher mpya</strong></div><div id="step3-status"></div></div>
</div>
<div id="errorMsgProgress" class="error" style="display:none"></div>
</div>
<div id="resultSection" class="result">
<div class="user-info">
<h3>📋 Voucher Imepatikana:</h3>
<div id="userDetails" class="user-details"></div>
</div>
<button id="repairBtn" class="btn">🔧 Bonyeza Hapa Kurekebisha</button>
</div>
<div id="successSection" class="success">
<div class="voucher-display">
<div>TAYARI VOCHA YAKO IMEREKEBISHWA.. ASANTE KWA KUTUMIA JIACHIE WIFI</div>
<div id="finalVoucher" class="voucher-code"></div>
</div>
<button id="copyBtn" class="btn" style="background:linear-gradient(135deg,#28a745,#20c997)">📋 Nakili Voucher YAKO UKAITUMIE TENA</button>
</div>
</div>
</div>
<script>
let foundUser = null, retryCount = 0;
const MAX_RETRIES = 10;
let currentTempVoucher = null; // To store temp voucher for WA message

function saveSt(s) {
    const e = new Date();
    e.setTime(e.getTime() + 864e5);
    document.cookie = `repair_state=${encodeURIComponent(JSON.stringify(s))};expires=${e.toUTCString()};path=/`;
}

function loadSt() {
    const s = document.cookie.split(";");
    for (let e of s) {
        const [t, r] = e.trim().split("=");
        if ("repair_state" === t) {
            try {
                return JSON.parse(decodeURIComponent(r));
            } catch (e) {
                return null;
            }
        }
    }
    return null;
}

function clearSt() {
    document.cookie = "repair_state=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/";
    currentTempVoucher = null;
}

window.addEventListener("load", function() {
    const e = loadSt();
    if (e && e.foundUser && confirm("Una voucher uliyokuwa unairekebisha. Unataka kuendelea?")) {
        foundUser = e.foundUser;
        retryCount = e.retryCount || 0;
        if (e.currentStep > 0) {
            document.getElementById("searchSection").style.display = "none";
            document.getElementById("progressSection").style.display = "block";
            if (e.step1_completed) {
                document.getElementById("step1").className = "progress-step completed";
                document.getElementById("step1-status").innerHTML = "✅";
            }
            if (e.step2_completed) {
                document.getElementById("step2").className = "progress-step completed";
                document.getElementById("step2-status").innerHTML = "✅";
            }
            if (confirm("Mchakato ulisimama. Jaribu tena?")) {
                if (e.step1_completed) {
                    if (e.step2_completed) {
                        retryStep("add_user", 3);
                    } else {
                        retryStep("remove_cookies", 2);
                    }
                } else {
                    retryStep("remove_user", 1);
                }
            }
        } else {
            showResult(foundUser);
        }
    } else {
        clearSt();
    }
});

document.getElementById("searchBtn").addEventListener("click", function() {
    const e = document.getElementById("voucherInput").value.trim();
    if (e.length >= 7) {
        retryCount = 0;
        search(e);
    } else {
        showErr("Weka voucher yako (angalau herufi 7)");
    }
});

document.getElementById("voucherInput").addEventListener("keypress", function(e) {
    if (e.key === "Enter") {
        document.getElementById("searchBtn").click();
    }
});

function search(e) {
    document.getElementById("errorMsg").style.display = "none";
    document.getElementById("resultSection").style.display = "none";
    const t = document.getElementById("searchBtn");
    const r = t.innerHTML;
    t.innerHTML = '<div style="display:inline-block;width:20px;height:20px;border:3px solid #fff;border-top:3px solid transparent;border-radius:50%;animation:spin 1s linear infinite"></div> Inatafuta...';
    t.disabled = true;
    
    // Increase timeout for fetch
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 30000); // 30 second timeout
    
    fetch(window.location.href, {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: `action=search_voucher&voucher=${encodeURIComponent(e)}`,
        signal: controller.signal
    }).then(e => e.json()).then(e => {
        clearTimeout(timeoutId);
        t.innerHTML = r;
        t.disabled = false;
        if (e.success) {
            foundUser = e.user;
            saveSt({foundUser: foundUser, currentStep: 0, retryCount: 0, step1_completed: false, step2_completed: false, step3_completed: false});
            showResult(e.user);
        } else {
            showErr(e.message.includes("haijapatikana") ? "Voucher yako haijapatikani. Jaribu kuiandika tena." : e.message);
        }
    }).catch(err => {
        clearTimeout(timeoutId);
        t.innerHTML = r;
        t.disabled = false;
        console.error('Search error:', err); // Log to console for debugging
        showErr("Kuna tatizo. Jaribu tena. (Timeout au mtandao)");
    });
}

function showResult(e) {
    document.getElementById("userDetails").innerHTML = `<p><strong>Jina:</strong> ${e.name}</p><p><strong>Password:</strong> ${e.password}</p><p><strong>Profile:</strong> ${e.profile}</p>${e.comment ? "<p><strong>Comment:</strong> " + e.comment + "</p>" : ""}`;
    document.getElementById("resultSection").style.display = "block";
}

function showErr(e) {
    document.getElementById("errorMsg").textContent = e;
    document.getElementById("errorMsg").style.display = "block";
}

function retryStep(e, t) {
    const r = document.getElementById("step" + t);
    r.className = "progress-step active";
    let s = '<div class="spinner"></div>';
    if (retryCount > 0) {
        s += `<div style="font-size:0.8em;margin-top:5px">Jaribu ${retryCount}/${MAX_RETRIES}</div>`;
    }
    r.querySelector("[id$='-status']").innerHTML = s;
    
    // Increase timeout for repair steps
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 45000); // 45 second timeout for repair steps
    
    fetch(window.location.href, {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: `action=repair_step&step=${e}&user_data=${encodeURIComponent(JSON.stringify(foundUser))}`,
        signal: controller.signal
    }).then(resp => resp.json()).then(s => {
        clearTimeout(timeoutId);
        console.log('Repair response for step', e, s); // Log response for debugging
        
        if (s.success) {
            r.className = "progress-step completed";
            r.querySelector("[id$='-status']").innerHTML = "✅";
            retryCount = 0;
            const n = loadSt() || {};
            n[`step${t}_completed`] = true;
            n.currentStep = t;
            saveSt(n);
            
            // Check specifically for add_user success
            if (s.step_completed === "add_user") {
                console.log('Add user succeeded, showing success UI'); // Debug log
                clearSt();
                showSuccess(s.voucher, s.password);
                return; // Ensure no further chaining
            } else if (s.step_completed === "remove_user") {
                // Small delay before next step to ensure UI updates
                setTimeout(() => retryStep("remove_cookies", 2), 500);
            } else if (s.step_completed === "remove_cookies") {
                setTimeout(() => retryStep("add_user", 3), 500);
            }
        } else {
            console.log('Repair failed for step', e, s.message); // Debug log
            retryCount++;
            if (retryCount < MAX_RETRIES) {
                // Update status to show retrying
                r.querySelector("[id$='-status']").innerHTML = `❓ Jaribu tena (${retryCount}/${MAX_RETRIES})...`;
                setTimeout(() => retryStep(e, t), 3000); // Increased retry delay to 3 seconds
            } else {
                r.className = "progress-step failed";
                r.querySelector("[id$='-status']").innerHTML = "❌";
                saveSt({...loadSt(), failedStep: e, retryCount: retryCount});
                showFinalFail(e);
            }
        }
    }).catch(err => {
        clearTimeout(timeoutId);
        console.error('Repair error for step', e, err); // Log error
        retryCount++;
        if (retryCount < MAX_RETRIES) {
            r.querySelector("[id$='-status']").innerHTML = `❓ Jaribu tena (${retryCount}/${MAX_RETRIES})...`;
            setTimeout(() => retryStep(e, t), 3000);
        } else {
            r.className = "progress-step failed";
            r.querySelector("[id$='-status']").innerHTML = "❌";
            saveSt({...loadSt(), failedStep: e, retryCount: retryCount});
            showFinalFail(e);
        }
    });
}

function showFinalFail(e) {
    const t = loadSt();
    const r = document.getElementById("errorMsgProgress");
    
    let html = `<h3>Pole sana!</h3><p>Tumejaribu ${MAX_RETRIES} mara. `;
    html += `Tutakupa voucher ya muda kidogo.</p>`;
    html += `<div style="margin:20px 0"><input type="tel" id="phone" placeholder="0712345678" style="padding:10px;font-size:1.1em;border:2px solid #ddd;border-radius:5px;width:100%;max-width:300px"></div><button onclick="copyTempAndSendWA()" style="background:#28a745;color:white;border:none;padding:15px 30px;font-size:1.1em;border-radius:25px;cursor:pointer;font-weight:600">📋 Copy Voucher ya Muda na Tuma WhatsApp</button>`;
    
    r.innerHTML = html;
    r.style.display = "block";
    
    // Log failure
    fetch(window.location.href, {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: `action=log_failure&step=${e}&user_data=${encodeURIComponent(JSON.stringify(foundUser))}&retry_count=${retryCount}`
    }).catch(err => console.error('Log failure error:', err));
}

function copyTempAndSendWA() {
    const phone = document.getElementById("phone").value.trim();
    if (phone.length < 10) {
        showErr("Weka nambari sahihi (angalau tarakimu 10)");
        return;
    }
    
    // Show loading
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<div style="display:inline-block;width:20px;height:20px;border:3px solid #fff;border-top:3px solid transparent;border-radius:50%;animation:spin 1s linear infinite"></div> Inatengeneza...';
    btn.disabled = true;
    
    fetch(window.location.href, {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: `action=create_temp_voucher&data=${encodeURIComponent(JSON.stringify({phone: phone, original_voucher: foundUser.name, profile: "masaa3"}))}`
    }).then(resp => resp.json()).then(t => {
        btn.innerHTML = originalText;
        btn.disabled = false;
        
        if (t.success) {
            currentTempVoucher = t.voucher;
            const voucherText = t.voucher; // Copy only the voucher number
            
            // Copy to clipboard
            if (navigator.clipboard) {
                navigator.clipboard.writeText(voucherText).then(() => {
                    alert(`Voucher yako ya muda imetengenezwa na imecopy!\n${voucherText}\n\nItaisha baada ya masaa 3.\n\nSasa tunaelekeza WhatsApp na maelezo haya.`);
                }).catch(() => {
                    alert(`Voucher yako ya muda imetengenezwa!\n${voucherText}\n\nCopy hii info na uweke router.\n\nSasa tunaelekeza WhatsApp na maelezo haya.`);
                });
            } else {
                alert(`Voucher yako ya muda imetengenezwa!\n${voucherText}\n\nCopy hii info na uweke router.\n\nSasa tunaelekeza WhatsApp na maelezo haya.`);
            }
            
            // Automatically send WA with temp voucher
            contactWA(true, phone, t.voucher);
            // Show success UI with temp voucher
            showSuccess(t.voucher, t.voucher);
        } else {
            showErr(t.message || "Kuna tatizo kuunda voucher ya muda. Tuma WhatsApp bila.");
            // Send WA without temp
            contactWA(true, phone, null);
        }
    }).catch(err => {
        btn.innerHTML = originalText;
        btn.disabled = false;
        console.error('Temp voucher error:', err);
        showErr("Kuna tatizo kuunda voucher ya muda. Tuma WhatsApp bila.");
        contactWA(true, phone, null);
    });
}

function showSuccess(e, t) {
    document.getElementById("progressSection").style.display = "none";
    document.getElementById("finalVoucher").textContent = e;
    document.getElementById("successSection").style.display = "block";
    localStorage.setItem("lastVoucher", e);
}

window.contactWA = function(includeTemp = false, phone = "", tempVoucher = "") {
    const s = loadSt();
    let n = `Habari, ninahitaji msaada na voucher yangu.\n\nVoucher: ${foundUser ? foundUser.name : "N/A"}\n`;
    
    if (s) {
        n += "\nMaendeleo:\n";
        n += `${s.step1_completed ? "✅ Done" : "❌ Not done"} - Kufuta voucher\n`;
        n += `${s.step2_completed ? "✅ Done" : "❌ Not done"} - Kufuta cookies\n`;
        n += `${s.step3_completed ? "✅ Done" : "❌ Not done"} - Kuongeza voucher mpya\n`;
        n += `\nJaribu: ${s.retryCount || 0} mara\n`;
    }
    
    if (includeTemp && phone) {
        n += `\nNambari: ${phone}`;
        if (tempVoucher || currentTempVoucher) {
            const voucherToSend = tempVoucher || currentTempVoucher;
            n += `\nVoucher ya muda: ${voucherToSend} (Username na Password ni sawa)\nImeundwa kwa ajili ya kurekebisha tatizo.\n\nBonyeza hii link kuingiza voucher: http://10.0.0.1\nMaagizo: Fungua link, weka username na password (ni sawa).`;
        } else {
            n += `\nHakuna voucher ya muda iliyoundwa (tatizo la kuunda).\n\nBonyeza hii link kuingiza voucher: http://10.0.0.1\nMaagizo: Fungua link, weka username na password (ni sawa).`;
        }
    }
    
    n += `\n\nTafadhali nisaidie haraka!`;
    
    window.open(`https://wa.me/255624783545?text=${encodeURIComponent(n)}`, "_blank");
};

document.getElementById("repairBtn").addEventListener("click", function() {
    if (foundUser) {
        document.getElementById("resultSection").style.display = "none";
        document.getElementById("searchSection").style.display = "none";
        document.getElementById("progressSection").style.display = "block";
        retryCount = 0;
        retryStep("remove_user", 1);
    }
});

document.getElementById("copyBtn").addEventListener("click", function() {
    const e = localStorage.getItem("lastVoucher");
    if (e) {
        const r = e; // Copy only the raw voucher number
        if (navigator.clipboard) {
            navigator.clipboard.writeText(r).then(() => {
                alert(`${r}\n\nVoucher imecopy! Utapelekwa router.`);
                window.location.href = "http://10.0.0.1";
            }).catch(() => {
                alert(`${r}\n\nCopy hii voucher na uweke router.`);
                window.location.href = "http://10.0.0.1";
            });
        } else {
            alert(`${r}\n\nCopy hii voucher na uweke router.`);
            window.location.href = "http://10.0.0.1";
        }
    }
});
</script>
</body>
</html>