<?php
/*
 *  JIHUDUMIE HAPA - WiFi Self Service Page
 *  Copyright (C) 2018 Laksamadi Guko.
 *
 *  Save as: /xampp/htdocs/mikhmonB/jihudumie_hapa.php
 */

session_start();
error_reporting(0); // hide errors for customers

// Router settings (replace with yours)
$router_ip   = "192.168.88.1"; 
$router_user = "admin"; 
$router_pass = "admin"; 
$router_port = "8728";

// Captive portal login URL (adjust to your hotspot login page)
$captive_url = "http://192.168.88.1/login";

// include RouterOS API
require_once("routeros_api.class.php");
$API = new RouterosAPI();

$message = "";
$voucher_data = null;

// Handle voucher check
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['voucher_code'])) {
    $voucher = trim($_POST['voucher_code']);

    if ($API->connect($router_ip, $router_user, $router_pass, $router_port)) {
        $API->write("/ip/hotspot/user/print", false);
        $API->write("?name=".$voucher);
        $result = $API->read();

        if (!empty($result)) {
            $voucher_data = $result[0];
        } else {
            $message = "Samahani, vocha hii haipo au imekwisha muda.";
        }
        $API->disconnect();
    } else {
        $message = "Tatizo la kuunganisha na router. Tafadhali jaribu tena.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>JiHudumie Hapa - Self Service WiFi</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; background: #f4f4f4; }
        .container { width: 400px; margin: 50px auto; background: #fff; padding: 20px; border-radius: 10px; }
        input[type=text] { width: 80%; padding: 10px; margin: 10px 0; border: 1px solid #ccc; border-radius: 5px; }
        input[type=submit] { padding: 10px 20px; border: none; background: #28a745; color: #fff; border-radius: 5px; cursor: pointer; }
        .voucher-info { margin-top: 20px; background: #e9ffe9; padding: 15px; border-radius: 5px; }
        .error { color: red; margin-top: 15px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Karibu JiHudumie Hapa</h2>
        <p>Ingiza vocha yako ili kuunganisha kwenye mtandao</p>

        <form method="post">
            <input type="text" name="voucher_code" placeholder="Weka vocha hapa..." required>
            <br>
            <input type="submit" value="Angalia Vocha">
        </form>

        <?php if ($message): ?>
            <div class="error"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <?php if ($voucher_data): ?>
            <div class="voucher-info">
                <h3>✅ Vocha Yako Imefanikiwa</h3>
                <p><b>Username:</b> <?= htmlspecialchars($voucher_data['name']) ?></p>
                <p><b>Uptime Limit:</b> <?= htmlspecialchars($voucher_data['limit-uptime']) ?></p>
                <p><b>Data Limit:</b> <?= htmlspecialchars($voucher_data['limit-bytes-total']) ?></p>
                <p><b>Status:</b> <?= htmlspecialchars($voucher_data['disabled'] == "true" ? "Imefungwa" : "Inatumika") ?></p>
                <a href="<?= $captive_url ?>?username=<?= urlencode($voucher_data['name']) ?>&password=<?= urlencode($voucher_data['password']) ?>" target="_blank">👉 Unganisha Sasa</a>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
