<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h3>Testing MikHmon Connection</h3>";

// Test 1: Check if files exist
echo "<h4>1. Checking if files exist:</h4>";
$files = [
    './include/config.php',
    './include/readcfg.php',
    './lib/routeros_api.class.php'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        echo "✓ Found: $file<br>";
    } else {
        echo "✗ NOT FOUND: $file<br>";
    }
}

// Test 2: Try to include files
echo "<h4>2. Trying to include files:</h4>";
try {
    include('./include/config.php');
    echo "✓ config.php loaded<br>";
} catch (Exception $e) {
    echo "✗ config.php failed: " . $e->getMessage() . "<br>";
}

try {
    include('./include/readcfg.php');
    echo "✓ readcfg.php loaded<br>";
} catch (Exception $e) {
    echo "✗ readcfg.php failed: " . $e->getMessage() . "<br>";
}

try {
    include_once('./lib/routeros_api.class.php');
    echo "✓ routeros_api.class.php loaded<br>";
} catch (Exception $e) {
    echo "✗ routeros_api.class.php failed: " . $e->getMessage() . "<br>";
}

// Test 3: Check variables
echo "<h4>3. Checking connection variables:</h4>";
if (isset($iphost)) {
    echo "✓ IP Host: $iphost<br>";
} else {
    echo "✗ IP Host not set<br>";
}

if (isset($userhost)) {
    echo "✓ User Host: $userhost<br>";
} else {
    echo "✗ User Host not set<br>";
}

if (function_exists('decrypt')) {
    echo "✓ decrypt() function exists<br>";
} else {
    echo "✗ decrypt() function NOT found<br>";
}

// Test 4: Try API connection
echo "<h4>4. Testing API Connection:</h4>";
if (class_exists('RouterosAPI')) {
    echo "✓ RouterosAPI class exists<br>";
    
    $API = new RouterosAPI();
    $API->debug = false;
    
    if (isset($iphost) && isset($userhost) && function_exists('decrypt')) {
        if ($API->connect($iphost, $userhost, decrypt($passwdhost))){
            echo "✓✓✓ <strong style='color:green'>CONNECTED TO ROUTER!</strong><br>";
            
            // Test a simple command
            $identity = $API->comm("/system/identity/print");
            if ($identity) {
                echo "✓ Router name: " . $identity[0]['name'] . "<br>";
            }
        } else {
            echo "✗ <strong style='color:red'>Connection FAILED</strong><br>";
            echo "Check: Router IP, Username, Password, API port enabled<br>";
        }
    } else {
        echo "✗ Missing connection parameters<br>";
    }
} else {
    echo "✗ RouterosAPI class NOT found<br>";
}

echo "<h4>Current Directory:</h4>";
echo getcwd();
?>